\version "2.18.0"
\language "deutsch"

\paper {
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  ragged-last-bottom=##f
  bottom-margin = 10\mm
  %system-count = #2
}

% diacritice: ă â î ş ţ

\header {
  title = "Bună dimineaţa la Moş Ajun"
  composer = "A. Podoleanu"
  arranger = "Ioan D. Chirescu"
  tagline = ""
  meter = "Moderato"
}

global = {
  \key b \major
  \time 2/4
  \autoBeamOff
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Bu -- nă di -- mi -- nea -- ţa la Moş A -- jun!
  Ne daţi ori nu ne daţi?
  Ne daţi ori nu ne daţi?
  Ne daţi, ne daţi? __

  Am ve -- nit şi noi o -- da -- tă,
  La un an cu să -- nă -- ta -- te,
  Dom -- nul sfânt să ne a -- ju -- te
  La co -- vrigi şi la nuci mul -- te.
}

tenorWords = \lyricmode {
  Bu -- nă di -- mi -- nea -- ţa la Moş A -- jun!
  Ne daţi ori nu ne daţi?
  Ne daţi ori nu ne daţi?
  Ne daţi, ne daţi? __
}

bassWords = \lyricmode {
  la Moş A -- jun, la Moş A -- jun!
  Ne daţi ori nu ne daţi?
  Ne daţi, ne daţi, ne daţi? __
}

sopMusic = \relative c' {
  f8^\markup{
      \hspace #-5.0
      \musicglyph #"scripts.segno"
      \hspace #2.0
      \musicglyph #"m"
      \hspace #-1.0
      \musicglyph #"f"
    }^\<
    f8 f8 f8\!
    d'4.^\accent c16 b16
    a4 g4^\>
    f4\! h8\rest b8^\p
    a8 c8 g8 a8
    \break
    b4 h8\rest b8^\mf
    a8 c8 g8 a8
    b8 h16\rest b16^\< c8 h16\rest c16\!
    d2~^\ff
    d4 h4\rest^\markup { Fine }
    \bar":|."
  \break

  c8^\mf c8^\markup { \bold "Più vivo" } c8 d8
  c8 b8 a8 b8
  c8 c8 c8 d8
  c8 b8 a8 b8
  \break
  c8 c8 c8 d8
  c8 b8 a8 b8
  c8 c8 c8 d8
  c8^\markup { \bold "poco rit."} b8
  a8^\markup {
    \raise #2.0 D'al
    \hspace #0.5
    \raise #3.0 \musicglyph #"scripts.segno"
    \raise #2.0 { al Fine }
  }^\> g8\!
  \bar "|."    
}

altMusic = \relative c' {
  f8 f8 f8 f8
    b4. a16 g16
    f4 es4
    d4 h'8\rest d,8
    f8 f8 es8 es8
    d4 h'8\rest d,8
    f8 f8 es8 es8
    d8 h'16\rest b16 a8 h16\rest a16
    b2~
    b4 h4\rest

  a8 a8 a8 b8
  a8 g8 f8 g8
  a8 a8 a8 b8
  a8 g8 f8 g8
  a8 a8 a8 b8
  a8 g8 f8 g8
  a8 a8 a8 b8
  a8 g8 f8 e8
} 	

tenorMusic = \relative c' {
  f8^\mf^\< f16([ es16)] d8 c8\!
    b8([^\accent c8)] d8 es8
    f4 f,4^\>
    b4\! r8 b8^\p
    c8 c8 c8 d16([ c16)]
    b4 r8 b8^\mf
    c8 c8 c8 d16([ c16)]
    b8 r16 d16^\<
    <<
      {
        \voiceOne
        f8 b,16\rest f'16\!
        f2~^\ff
        f4
      }
      \new Voice = "split" {
        \voiceTwo
        es8 b16\rest es16
        d2~
        d4
      }
    >>
    \oneVoice
    r4
    \bar":|."

  R2 R2 R2 R2 R2 R2 R2 R2
}

bassMusic = \relative c' {
  R2 R2
    r8 f,8^\accent^\mf g8^\accent a8^\accent
    b8^\accent f8^\accent d8^\accent b8^\accent
    f'4^\accent r8 f8^\accent^\p
    b8^\accent f8^\accent d8^\accent b8^\accent
    f'4^\accent r8 f8^\mf
    b8 r16 b16^\< f8 r16 f16\!
    b2~^\ff
    b4 r4
    \bar":|."

  R2 R2 R2 R2 R2 R2 R2 R2  
}  	

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \global \voiceOne \sopMusic }
     \addlyrics { \sopWords }
     \new Voice { \global \voiceTwo \altMusic }
     %\addlyrics { \altoWords }
    >>
    \new Staff <<
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \tenorWords }
    >>

    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
   \layout {
    \context {
      \RemoveEmptyStaffContext
    }
   }
}

midiOutput = \midi {
  \tempo 4 = 70
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}